CREATE OR REPLACE FUNCTION sim2_activity_personnel(p_tsrfdact_is_number IN NUMBER,
                                                   p_tsrfdact_org_id    IN VARCHAR2) RETURN VARCHAR2 IS 
  v_person VARCHAR2(2000);

  CURSOR person_cur(p_tsrfdact_is_number IN NUMBER,
                    p_tsrfdact_org_id    IN CHAR) IS
    SELECT last_name||' '||first_name name
    FROM   tsrfapea a,
           tsmpersn p
    WHERE  p.tsmpersn_is_number = a.tsmpersn_is_number
    AND    p.tsmpersn_org_id    = a.tsmpersn_org_id
    AND    a.tsrfdact_is_number = p_tsrfdact_is_number
    AND    a.tsrfdact_org_id    = p_tsrfdact_org_id;

BEGIN
  FOR person_rec IN person_cur(p_tsrfdact_is_number, p_tsrfdact_org_id) LOOP
    IF v_person IS NULL THEN
      v_person := person_rec.name;
    ELSE
      v_person := v_person||'\'||person_rec.name;
    END IF;
  END LOOP;
  
  RETURN v_person;
END sim2_activity_personnel;
/


